// CLS_dlgPopUpWindow.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_dlgPopUpWindow.h"
#include "Include\CommonFun.h"
#include "Include/CLS_NVDSDK_Interface.h"

#define DISABLE								0
#define ENABLE								1

// CLS_dlgPopUpWindow Ի
#define DEFAULT_SCREEN_SIZE	10000
#define DEFAULT_PIC_SIZE	1000
#define PIC_COLOR		RGB(2, 153, 0)
#define BACK_COLOR		RGB(0, 0, 0)
#define LINE_COLOR		RGB(255, 0, 0)
#define WINDOW_COLOR	RGB(255, 0, 0)
IMPLEMENT_DYNAMIC(CLS_dlgPopUpWindow, CDialog)

#ifdef SDK_X64
#define GCL_HCURSOR GCLP_HCURSOR
#endif

CLS_dlgPopUpWindow::CLS_dlgPopUpWindow(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_dlgPopUpWindow::IDD, pParent)
{
	m_lLogonID = -1;
	m_iChannelNo = 0;
	m_iRectHeight = 0;
	m_iRectWidth = 0;
	m_iRow = 3;
	m_iCol = 3;
	m_iCurPicNo = 0;
	m_bMoveRect = FALSE;
	m_bMoveLine = FALSE;

	memset(m_stFloatWindow, 0, sizeof(FloatWindow)*4);	
}

CLS_dlgPopUpWindow::~CLS_dlgPopUpWindow()
{
}

void CLS_dlgPopUpWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_NO, m_cboChannelNo);
	DDX_Control(pDX, IDC_CBO_POS_NO, m_cboWindowNo);
	DDX_Control(pDX, IDC_CBO_ENABLE, m_cboEnable);
	DDX_Control(pDX, IDC_STATIC_PICTURE_CUT, m_staticVideoPosition);
	DDX_Control(pDX, IDC_EDT_X, m_edtX);
	DDX_Control(pDX, IDC_EDT_Y, m_edtY);
	DDX_Control(pDX, IDC_EDT_W, m_edtW);
	DDX_Control(pDX, IDC_EDT_H, m_edtH);
	DDX_Control(pDX, IDC_CBO_VISIBLE_OR_NOT, m_cboVisibleOrNot);
	DDX_Control(pDX, IDC_CBO_POS_NO_EASYX, m_cboWindowsIdByEasyX);
}


BEGIN_MESSAGE_MAP(CLS_dlgPopUpWindow, CDialog)

	ON_CBN_SELCHANGE(IDC_COMBO_NO, &CLS_dlgPopUpWindow::OnCbnSelchangeComboNo)
	ON_CBN_SELCHANGE(IDC_CBO_POS_NO, &CLS_dlgPopUpWindow::OnCbnSelchangeCboPosNo)
	ON_WM_SHOWWINDOW()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BTN_SET, &CLS_dlgPopUpWindow::OnBnClickedBtnSet)
	ON_EN_KILLFOCUS(IDC_EDT_X, &CLS_dlgPopUpWindow::OnEnKillfocusEdtX)
	ON_EN_KILLFOCUS(IDC_EDT_Y, &CLS_dlgPopUpWindow::OnEnKillfocusEdtY)
	ON_EN_KILLFOCUS(IDC_EDT_W, &CLS_dlgPopUpWindow::OnEnKillfocusEdtW)
	ON_EN_KILLFOCUS(IDC_EDT_H, &CLS_dlgPopUpWindow::OnEnKillfocusEdtH)
	ON_BN_CLICKED(IDC_BTN_SET_VIS_OR_NOT, &CLS_dlgPopUpWindow::OnBnClickedBtnSetVisOrNot)
	ON_BN_CLICKED(IDC_BTN_SET_AREA, &CLS_dlgPopUpWindow::OnBnClickedBtnSetArea)
	ON_BN_CLICKED(IDC_BTN_SET_WINDOW_EASYX, &CLS_dlgPopUpWindow::OnBnClickedBtnSetWindowEasyx)
END_MESSAGE_MAP()


int CLS_dlgPopUpWindow::Initialize(TDECPARAM* _pdecParam)
{
	if (_pdecParam == NULL)
	{
		return -1;
	}
	m_iChannelNo = _pdecParam->m_iChannel;
	UpdatePosData();
	UpdateVisibleData();
	return 0;
}

void CLS_dlgPopUpWindow::UpdatePosData()
{
	int iPos = 0;
	BaseOffset tGetStartAddress;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_dlgPopUpWindow::UpdatePosData][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
	}

	m_iChannelNo = GetComboData(&m_cboChannelNo);
	for(iPos = 0;iPos < DEC_MAX_FLOAT_WINDOW_NUM;iPos++)
	{
		FloatWindow tFloatWindow;
		tFloatWindow.iEnable = 0;
		tFloatWindow.iSize = 0;
		tFloatWindow.tArea.iBufSize = 0 ;
		tFloatWindow.tArea.iHeight = 0;
		tFloatWindow.tArea.iWidth = 0;
		tFloatWindow.tArea.iX = 0;
		tFloatWindow.tArea.iY = 0;
		DEC_ClientGetDevConfig(m_lLogonID, m_iChannelNo, iPos + tGetStartAddress.iFloatWindow, 
			CMD_DEC_CFG_FLOAT_WINDOW, &tFloatWindow, sizeof(FloatWindow));

		if(tFloatWindow.iEnable == 1)
		{
			m_stFloatWindow[iPos].iEnable = tFloatWindow.iEnable;
			m_stFloatWindow[iPos].iSize = tFloatWindow.iSize;
			m_stFloatWindow[iPos].tArea = tFloatWindow.tArea;
		}
		else
		{
			memset(&m_stFloatWindow[iPos], 0, sizeof(FloatWindow));
		}	
	}

	DrawMutiPicArea();
	int iSelectPos = m_cboWindowNo.GetCurSel();
	SetDlgItemInt(IDC_EDT_X,m_stFloatWindow[iSelectPos].tArea.iX);
	SetDlgItemInt(IDC_EDT_Y,m_stFloatWindow[iSelectPos].tArea.iY);
	if(m_stFloatWindow[iSelectPos].iEnable == 1)
	{
		SetDlgItemInt(IDC_EDT_W,m_stFloatWindow[iSelectPos].tArea.iWidth);
		SetDlgItemInt(IDC_EDT_H,m_stFloatWindow[iSelectPos].tArea.iHeight);
	}
	else
	{
		SetDlgItemInt(IDC_EDT_W,1000);
		SetDlgItemInt(IDC_EDT_H,1000);
	}
	m_cboEnable.SetCurSel(m_stFloatWindow[iSelectPos].iEnable);
	
}

void CLS_dlgPopUpWindow::UpdateVisibleData()
{
	int iChannel = GetComboData(&m_cboChannelNo);
	int iPos = GetComboData(&m_cboWindowNo);
	DecScreenDisplay tDecScrDis = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannel, iPos, CMD_DEC_CFG_SCREEN_DISPLAY, &tDecScrDis, sizeof(DecScreenDisplay));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_dlgPopUpWindow::UpdateVisobleData] DEC_ClientGetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",iRet, GetLastError(), CMD_DEC_CFG_SCREEN_DISPLAY);
		return;
	}
	m_cboVisibleOrNot.SetCurSel(tDecScrDis.iDisplay);
}


BOOL CLS_dlgPopUpWindow::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetDlgItemText(IDC_BTN_PIC_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_STATIC_PAGE_SET, GetText(IDS_SETTING_PAGE_SET));
	SetDlgItemText(IDC_STATIC_NO, GetText(IDS_CFG_LOG_DVR_CHANNEL));
	SetDlgItemText(IDC_STATIC_PIC_NUM, GetText(IDS_STRING_PAGE_NUM));
	SetDlgItemText(IDC_STATIC_CUSTOM_CUT, GetText(IDS_STRING_CUSTOM_PAGE_CUT));

	CreateChannelCombo(m_lLogonID, &m_cboChannelNo);

	CString cstrScreenNo;
	BaseOffset tGetStartAddress;//ȡƫ
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
	}
	int iIndexChannel = 0;
	for(int i = 0; i < DEC_MAX_FLOAT_WINDOW_NUM; i++)
	{
		cstrScreenNo.Format("%s%d", GetText(IDS_POPUP_SCREEN), i+1);
		iIndexChannel = m_cboWindowNo.AddString(cstrScreenNo);
		m_cboWindowNo.SetItemData(iIndexChannel, i + tGetStartAddress.iFloatWindow);
	}
	m_cboWindowNo.SetCurSel(0);

	for (int i = 0; i < DEC_MAX_PICTURE_NUM; ++i)
	{
		cstrScreenNo.Format("%s%d", GetText(IDS_POPUP_SCREEN), i+1);
		iIndexChannel = m_cboWindowsIdByEasyX.AddString(cstrScreenNo);
		m_cboWindowsIdByEasyX.SetItemData(iIndexChannel, i);
	}
	m_cboWindowsIdByEasyX.SetCurSel(0);

	m_cboEnable.AddString("ʹ");
	m_cboEnable.AddString("ʹ");
	m_cboEnable.SetCurSel(0);

	m_cboVisibleOrNot.AddString("");
	m_cboVisibleOrNot.AddString("ʾ");
	m_cboVisibleOrNot.SetCurSel(0);

	RECT rect = {0};
	GetDlgItem(IDC_STATIC_PICTURE_CUT)->GetWindowRect(&rect);
	m_iRectWidth = rect.right - rect.left;
	m_iRectHeight = rect.bottom - rect.top;

	m_edtX.SetLimitText(5);
	m_edtY.SetLimitText(5);
	m_edtW.SetLimitText(5);
	m_edtH.SetLimitText(5);



	m_cboWindowNo.SetCurSel(0);
	m_cboEnable.SetCurSel(0);


	return TRUE;
}

void CLS_dlgPopUpWindow::OnCbnSelchangeComboNo()
{
	GetScreenInfo();
	UpdateVisibleData();
}

void CLS_dlgPopUpWindow::GetScreenInfo()
{
	UpdatePosData();
	DrawMutiPicArea();
}

void CLS_dlgPopUpWindow::DrawMutiPicArea()
{
	CWnd *pWnd = GetDlgItem(IDC_STATIC_PICTURE_CUT);
	if (pWnd == NULL)
	{
		return;
	}
	CDC *pCDC = pWnd->GetDC();
	if (pCDC == NULL)
	{
		return;
	}

	CBitmap bitmap;
	if (0 == bitmap.CreateCompatibleBitmap(pCDC, m_iRectWidth, m_iRectHeight))
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]CreateCompatibleBitmap Failed!");
	}

	CDC memDC;
	if (0 == memDC.CreateCompatibleDC(NULL))
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]CreateCompatibleDC Failed!");
	}

	CBitmap* pOldBitMap = memDC.SelectObject(&bitmap);
	memDC.FillSolidRect(0, 0, m_iRectWidth, m_iRectHeight, BACK_COLOR); //䱳ɫ
	memDC.SetBkMode(TRANSPARENT);
	memDC.SetMapMode(MM_ANISOTROPIC);
	memDC.SetViewportExt(m_iRectWidth, m_iRectHeight);
	memDC.SetWindowExt(DEFAULT_SCREEN_SIZE, DEFAULT_SCREEN_SIZE);

	int iX1 = 0;
	int iX2 = 0;
	int iY1 = 0;
	int iY2 = 0;
	CString strText;

	//ƻ
	CBrush* pOldBrush = NULL;
	CBrush brushPic(WINDOW_COLOR);

	pOldBrush = memDC.SelectObject(&brushPic);
	for (int i = 4; i > 0; i--)
	{
		if(m_stFloatWindow[i-1].iEnable == 0)
			continue;
		iX1 = m_stFloatWindow[i-1].tArea.iX;
		iX2 = iX1 + m_stFloatWindow[i-1].tArea.iWidth;
		iY1 = m_stFloatWindow[i-1].tArea.iY;
		iY2 = iY1 + m_stFloatWindow[i-1].tArea.iHeight;
		memDC.Rectangle(iX1, iY1, iX2, iY2);
		strText.Format("%d", i);
		memDC.TextOut(iX1 + 100, iY1 + 100, strText);
	}

	memDC.SelectObject(pOldBrush);

	//ͨ
	CPen penRed(PS_DASH, 0, LINE_COLOR);
	CPen* pOldPen = memDC.SelectObject(&penRed);
	for (int i = 1; i < m_iRow; i++)
	{
		memDC.MoveTo(0, (DEFAULT_SCREEN_SIZE*i)/m_iRow);
		memDC.LineTo(DEFAULT_SCREEN_SIZE, (DEFAULT_SCREEN_SIZE*i)/m_iRow);
	}

	for (int i = 1; i < m_iCol; i++)
	{
		memDC.MoveTo((DEFAULT_SCREEN_SIZE*i)/m_iCol, 0);
		memDC.LineTo((DEFAULT_SCREEN_SIZE*i)/m_iCol, DEFAULT_SCREEN_SIZE);
	}

	memDC.SelectObject(pOldPen);

	pCDC->StretchBlt(0, 0, m_iRectWidth, m_iRectHeight, &memDC, 0, 0, DEFAULT_SCREEN_SIZE, DEFAULT_SCREEN_SIZE, SRCCOPY);

	memDC.SelectObject(pOldBitMap);
	if (0 == bitmap.DeleteObject())
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]bitmap.DeleteObject() Failed!");
	}

	if (0 == memDC.DeleteDC())
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]memDC.DeleteDC() Failed!");
	}

	pWnd->ReleaseDC(pCDC);
}

void CLS_dlgPopUpWindow::OnPaint()
{
	CPaintDC dc(this); // ڻƵ豸
	DrawMutiPicArea();
	CDialog::OnPaint();	
}

LRESULT CLS_dlgPopUpWindow::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (GetDlgItem(IDC_STATIC_PICTURE_CUT))
	{
		RECT rc = {0};
		POINT pt = {0};
		GetCursorPos(&pt);

		GetDlgItem(IDC_STATIC_PICTURE_CUT)->GetWindowRect(&rc);

		if (::PtInRect(&rc, pt))
		{
			switch(message)
			{
			case WM_LBUTTONDOWN:
				{
					GetDlgItem(IDC_STATIC_PICTURE_CUT)->ScreenToClient(&pt);
					pt.x = pt.x * 10000 / m_iRectWidth;
					pt.y = pt.y * 10000 / m_iRectHeight;


					for (int i=0; i < 4; i++)
					{
						rc.left = m_stFloatWindow[i].tArea.iX;
						rc.right = rc.left + m_stFloatWindow[i].tArea.iWidth;
						rc.top = m_stFloatWindow[i].tArea.iY;
						rc.bottom = rc.top + m_stFloatWindow[i].tArea.iHeight;


						if (::PtInRect(&rc, pt))
						{
							m_iCurPicNo = i;
							m_cboWindowNo.SetCurSel(i);
							UpdatePosData();
							UpdateVisibleData();
							m_bMoveRect = TRUE;
							m_bMoveLine = FALSE;
							m_ptPrePoint = pt;
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZEALL));

							SetDlgItemInt(IDC_EDT_X, m_stFloatWindow[m_iCurPicNo].tArea.iX);
							SetDlgItemInt(IDC_EDT_Y, m_stFloatWindow[m_iCurPicNo].tArea.iY);
							SetDlgItemInt(IDC_EDT_W, m_stFloatWindow[m_iCurPicNo].tArea.iWidth);
							SetDlgItemInt(IDC_EDT_H, m_stFloatWindow[m_iCurPicNo].tArea.iHeight);

							break;
						}

						if (rc.right - 200 < pt.x 
							&& rc.right + 200 > pt.x 
							&& rc.bottom - 200 < pt.y
							&& rc.bottom + 200 >pt.y)
						{
							m_iCurPicNo = i;
							m_bMoveLine = TRUE;
							m_bMoveRect = FALSE;
							m_ptPrePoint = pt;
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZENWSE));
							break;
						}
					}
				}
				break;
			case WM_LBUTTONUP:
				{		
					m_bMoveRect = FALSE;
					m_bMoveLine = FALSE;
					SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));							
				}
				break;
			case WM_MOUSEMOVE:
				{
					GetDlgItem(IDC_STATIC_PICTURE_CUT)->ScreenToClient(&pt);
					pt.x = pt.x * DEFAULT_SCREEN_SIZE / m_iRectWidth;
					pt.y = pt.y * DEFAULT_SCREEN_SIZE / m_iRectHeight;
					if (m_bMoveRect || m_bMoveLine)
					{
						int iX = pt.x - m_ptPrePoint.x;
						int iY = pt.y - m_ptPrePoint.y;
						m_ptPrePoint = pt;				

						if (m_bMoveRect)
						{
							if (m_stFloatWindow[m_iCurPicNo].tArea.iX + iX < 0 
								|| m_stFloatWindow[m_iCurPicNo].tArea.iX  + iX + m_stFloatWindow[m_iCurPicNo].tArea.iWidth > DEFAULT_SCREEN_SIZE
								|| m_stFloatWindow[m_iCurPicNo].tArea.iY + iY < 0 
								|| m_stFloatWindow[m_iCurPicNo].tArea.iY + iY + m_stFloatWindow[m_iCurPicNo].tArea.iHeight > DEFAULT_SCREEN_SIZE)
							{
								break;
							}

							m_stFloatWindow[m_iCurPicNo].tArea.iX += iX;
							m_stFloatWindow[m_iCurPicNo].tArea.iY += iY;
						}

						if (m_bMoveLine)
						{
							if (m_stFloatWindow[m_iCurPicNo].tArea.iX  + iX + m_stFloatWindow[m_iCurPicNo].tArea.iWidth > DEFAULT_SCREEN_SIZE 
								|| m_stFloatWindow[m_iCurPicNo].tArea.iY + iY + m_stFloatWindow[m_iCurPicNo].tArea.iHeight > DEFAULT_SCREEN_SIZE)
							{
								break;
							}

							m_stFloatWindow[m_iCurPicNo].tArea.iHeight += iY;
							m_stFloatWindow[m_iCurPicNo].tArea.iWidth += iX;
						}

						if (m_stFloatWindow[m_iCurPicNo].tArea.iHeight < DEFAULT_PIC_SIZE)
						{
							m_stFloatWindow[m_iCurPicNo].tArea.iHeight = DEFAULT_PIC_SIZE;
						}

						if (m_stFloatWindow[m_iCurPicNo].tArea.iWidth < DEFAULT_PIC_SIZE)
						{
							m_stFloatWindow[m_iCurPicNo].tArea.iWidth = DEFAULT_PIC_SIZE;
						}

						DrawMutiPicArea();

						SetDlgItemInt(IDC_EDT_X, m_stFloatWindow[m_iCurPicNo].tArea.iX);
						SetDlgItemInt(IDC_EDT_Y, m_stFloatWindow[m_iCurPicNo].tArea.iY);
						SetDlgItemInt(IDC_EDT_W, m_stFloatWindow[m_iCurPicNo].tArea.iWidth);
						SetDlgItemInt(IDC_EDT_H, m_stFloatWindow[m_iCurPicNo].tArea.iHeight);
					}
					else
					{
						bool bExist = false;

						for (int i=0; i < 4; i++)
						{
							rc.left = m_stFloatWindow[i].tArea.iX;
							rc.right = rc.left + m_stFloatWindow[i].tArea.iWidth;
							rc.top = m_stFloatWindow[i].tArea.iY;
							rc.bottom = rc.top + m_stFloatWindow[i].tArea.iHeight;


							if (::PtInRect(&rc, pt))
							{
								SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZEALL));
								bExist = true;
								break;
							}

							if (rc.right - 200 < pt.x 
								&& rc.right + 200 > pt.x 
								&& rc.bottom - 200 < pt.y
								&& rc.bottom + 200 >pt.y)
							{
								SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZENWSE));
								bExist = true;
								break;
							}
						}

						if (!bExist)
						{
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));
						}
					}
				}
				break;
			default:
				break;
			}
		}	
		else
		{
			m_bMoveRect = FALSE;
			m_bMoveLine = FALSE;
			SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));							
		}
	}

	return CDialog::WindowProc(message, wParam, lParam);
}

void CLS_dlgPopUpWindow::OnEnKillfocusEdtX()
{
	// TODO: Add your control notification handler code here
	m_stFloatWindow[m_iCurPicNo].tArea.iX = GetDlgItemInt(IDC_EDT_X);
	if (m_stFloatWindow[m_iCurPicNo].tArea.iX > DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iX = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
	}

	if (m_stFloatWindow[m_iCurPicNo].tArea.iX + m_stFloatWindow[m_iCurPicNo].tArea.iWidth > DEFAULT_SCREEN_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iX = DEFAULT_SCREEN_SIZE - m_stFloatWindow[m_iCurPicNo].tArea.iWidth;
	}

	SetDlgItemInt(IDC_EDT_X, m_stFloatWindow[m_iCurPicNo].tArea.iX);

	//DrawMutiPicArea();
}

void CLS_dlgPopUpWindow::OnEnKillfocusEdtY()
{
	// TODO: Add your control notification handler code here
	m_stFloatWindow[m_iCurPicNo].tArea.iY = GetDlgItemInt(IDC_EDT_Y);
	if (m_stFloatWindow[m_iCurPicNo].tArea.iY > DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iY = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
	}

	if (m_stFloatWindow[m_iCurPicNo].tArea.iY + m_stFloatWindow[m_iCurPicNo].tArea.iHeight > DEFAULT_SCREEN_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iY = DEFAULT_SCREEN_SIZE - m_stFloatWindow[m_iCurPicNo].tArea.iHeight;
	}

	SetDlgItemInt(IDC_EDT_Y, m_stFloatWindow[m_iCurPicNo].tArea.iY);

	//DrawMutiPicArea();
}

void CLS_dlgPopUpWindow::OnEnKillfocusEdtW()
{
	// TODO: Add your control notification handler code here
	m_stFloatWindow[m_iCurPicNo].tArea.iWidth = GetDlgItemInt(IDC_EDT_W);
	if (m_stFloatWindow[m_iCurPicNo].tArea.iWidth < DEFAULT_PIC_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iWidth = DEFAULT_PIC_SIZE;
	}

	if (m_stFloatWindow[m_iCurPicNo].tArea.iX + m_stFloatWindow[m_iCurPicNo].tArea.iWidth > DEFAULT_SCREEN_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iWidth = DEFAULT_SCREEN_SIZE - m_stFloatWindow[m_iCurPicNo].tArea.iX;
	}

	SetDlgItemInt(IDC_EDT_W, m_stFloatWindow[m_iCurPicNo].tArea.iWidth);

	//DrawMutiPicArea();
}

void CLS_dlgPopUpWindow::OnEnKillfocusEdtH()
{
	// TODO: Add your control notification handler code here
	m_stFloatWindow[m_iCurPicNo].tArea.iHeight = GetDlgItemInt(IDC_EDT_H);
	if (m_stFloatWindow[m_iCurPicNo].tArea.iHeight < DEFAULT_PIC_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iHeight = DEFAULT_PIC_SIZE;
	}

	if (m_stFloatWindow[m_iCurPicNo].tArea.iY + m_stFloatWindow[m_iCurPicNo].tArea.iHeight > DEFAULT_SCREEN_SIZE)
	{
		m_stFloatWindow[m_iCurPicNo].tArea.iHeight = DEFAULT_SCREEN_SIZE - m_stFloatWindow[m_iCurPicNo].tArea.iY;
	}

	SetDlgItemInt(IDC_EDT_H, m_stFloatWindow[m_iCurPicNo].tArea.iHeight);

	//DrawMutiPicArea();
}

void CLS_dlgPopUpWindow::OnOK()
{
	// TODO: Add your specialized code here and/or call the base class
	if (GetFocus() == GetDlgItem(IDC_EDT_X))
	{
		OnEnKillfocusEdtX();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_Y))
	{
		OnEnKillfocusEdtY();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_W))
	{
		OnEnKillfocusEdtW();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_H))
	{
		OnEnKillfocusEdtH();
	}
}

void CLS_dlgPopUpWindow::OnCbnSelchangeCboPosNo()
{
	//int iPosNo = m_cboChannelNo.GetCurSel();
	m_iCurPicNo = m_cboWindowNo.GetCurSel();
	UpdatePosData();
	UpdateVisibleData();
}

void CLS_dlgPopUpWindow::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	if (bShow)
	{
		m_cboChannelNo.SetCurSel(0);
		GetScreenInfo();
		GetScreenAreaInfo();
	}	
}

void CLS_dlgPopUpWindow::GetScreenAreaInfo()
{
	int iVVOChannelNo = m_cboChannelNo.GetCurSel() + DEC_MAX_PHYSICAL_CHANNEL_NUM;
	if (iVVOChannelNo < DEC_MAX_PHYSICAL_CHANNEL_NUM || DEC_MAX_PHYSICAL_CHANNEL_NUM >= DEC_MAX_CHANNEL_TOTAL_NUM)
	{
		return;
	}

	int iPos = m_cboWindowNo.GetCurSel();
	if (iPos < 0 || iPos >= DEC_MAX_SPLIT_SCREEN_NUM)
	{
		return;
	}

	ScreenPara tScreenPara = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iVVOChannelNo, iPos
		, CMD_DEC_CFG_SCREEN_CHANGEAREA, &tScreenPara, sizeof(ScreenPara));
	if (0 == iRet)
	{
		/*SetDlgItemInt(IDC_EDT_X, tScreenPara.iX);
		SetDlgItemInt(IDC_EDT_Y, tScreenPara.iY);
		SetDlgItemInt(IDC_EDT_W, tScreenPara.iWidth);
		SetDlgItemInt(IDC_EDT_H, tScreenPara.iHeight);*/
		DrawMutiPicArea();
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] failed......\n"));
	}
}

void CLS_dlgPopUpWindow::OnBnClickedBtnSet()
{
	
	FloatWindow tWindowInfo = {0};
	tWindowInfo.iSize = sizeof(FloatWindow);
	tWindowInfo.iEnable = m_cboEnable.GetCurSel();
	m_iCurPicNo = m_cboWindowNo.GetCurSel();
	int iChannelNo = GetComboData(&m_cboChannelNo);
	int  iPosNo= GetComboData(&m_cboWindowNo);
	if(tWindowInfo.iEnable == 1)
	{
		tWindowInfo.tArea.iBufSize = sizeof(ScreenPara);
		tWindowInfo.tArea.iX = GetDlgItemInt(IDC_EDT_X);
		tWindowInfo.tArea.iY = GetDlgItemInt(IDC_EDT_Y);
		tWindowInfo.tArea.iWidth = GetDlgItemInt(IDC_EDT_W);
		tWindowInfo.tArea.iHeight = GetDlgItemInt(IDC_EDT_H);
	}
	else if(tWindowInfo.iEnable == 0)
	{
		tWindowInfo.tArea.iBufSize = sizeof(ScreenPara);
		tWindowInfo.tArea.iX = 0;
		tWindowInfo.tArea.iY = 0;
		tWindowInfo.tArea.iWidth = 0;
		tWindowInfo.tArea.iHeight = 0;
	}
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannelNo, iPosNo, CMD_DEC_CFG_FLOAT_WINDOW, &tWindowInfo, sizeof(FloatWindow));
	if(iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::OnBnClickedBtnSet] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",iRet, GetLastError(), CMD_DEC_CFG_FLOAT_WINDOW);
	}
	DrawMutiPicArea();
}



void CLS_dlgPopUpWindow::OnBnClickedBtnSetVisOrNot()
{
	int iSelect = m_cboVisibleOrNot.GetCurSel();
	DecScreenDisplay tDecScrDis = {0};
	tDecScrDis.iDisplay = iSelect;
	int iChannelNo = GetComboData(&m_cboChannelNo);
	int  iPosNo= GetComboData(&m_cboWindowNo);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannelNo, iPosNo, CMD_DEC_CFG_SCREEN_DISPLAY, &tDecScrDis, sizeof(DecScreenDisplay));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_dlgPopUpWindow::OnBnClickedBtnSetVisOrNot] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",iRet, GetLastError(), CMD_DEC_CFG_SCREEN_DISPLAY);
	}
}

void CLS_dlgPopUpWindow::OnBnClickedBtnSetArea()
{
	int iChannelNo = GetComboData(&m_cboChannelNo);
	int  iPosNo= GetComboData(&m_cboWindowNo);
	ScreenPara tArea = {0};
	tArea.iX = GetDlgItemInt(IDC_EDT_X);
	tArea.iY = GetDlgItemInt(IDC_EDT_Y);
	tArea.iWidth = GetDlgItemInt(IDC_EDT_W);
	tArea.iHeight = GetDlgItemInt(IDC_EDT_H);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannelNo, iPosNo, CMD_DEC_CFG_SCREEN_CHANGEAREA, &tArea, sizeof(ScreenPara));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_dlgPopUpWindow::OnBnClickedBtnSetArea] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",iRet, GetLastError(), CMD_DEC_CFG_SCREEN_CHANGEAREA);
	}
}

void CLS_dlgPopUpWindow::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_FLOAT_WINDOW:
		{
			GetScreenInfo();
			UpdateVisibleData();
		}
		break;
	}
}

void CLS_dlgPopUpWindow::OnBnClickedBtnSetWindowEasyx()
{
	FloatWindow tWindowInfo = {0};
	tWindowInfo.iSize = sizeof(FloatWindow);
	tWindowInfo.iEnable = m_cboEnable.GetCurSel();
	int iChannelNo = GetComboData(&m_cboChannelNo);
	int iWidnowsId = GetComboData(&m_cboWindowsIdByEasyX);
	if(ENABLE == tWindowInfo.iEnable)
	{
		tWindowInfo.tArea.iBufSize = sizeof(ScreenPara);
		tWindowInfo.tArea.iX = GetDlgItemInt(IDC_EDT_X);
		tWindowInfo.tArea.iY = GetDlgItemInt(IDC_EDT_Y);
		tWindowInfo.tArea.iWidth = GetDlgItemInt(IDC_EDT_W);
		tWindowInfo.tArea.iHeight = GetDlgItemInt(IDC_EDT_H);
	}
	else if(DISABLE == tWindowInfo.iEnable)
	{
		tWindowInfo.tArea.iBufSize = sizeof(ScreenPara);
		tWindowInfo.tArea.iX = 0;
		tWindowInfo.tArea.iY = 0;
		tWindowInfo.tArea.iWidth = 0;
		tWindowInfo.tArea.iHeight = 0;
	}
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannelNo, iWidnowsId, CMD_DEC_CFG_FLOAT_WINDOW, &tWindowInfo, sizeof(FloatWindow));
	if(iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::OnBnClickedBtnSetWindowEasyx] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",iRet, GetLastError(), CMD_DEC_CFG_FLOAT_WINDOW);
	}
	DrawMutiPicArea();
}
